// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /var/mnt/Data/CVS_REPO/Clients/Marketcircle/Frameworks/MCApplication/OFResourceFork.h,v 1.2 2006/01/14 02:22:47 alalani Exp $

//#import <OmniFoundation/OFObject.h>

#import <Foundation/Foundation.h>
#import <CoreServices/CoreServices.h>

@class NSArray, NSData, NSString;

extern NSString *OFDataForkName;
extern NSString *OFResourceForkName;

typedef enum _OFForkType {
    OFDataForkType,
    OFResourceForkType
} OFForkType;

@interface OFResourceFork : NSObject
{
    NSString   *path;
#if __LP64__
    int         refNum;
#else
    SInt16      refNum;
#endif  /* __LP64__ */

}

- initWithContentsOfFile: (NSString *) aPath forkType: (OFForkType) aForkType;
- initWithContentsOfFile: (NSString *) aPath;

- (NSString *) path;

- (NSArray *) stringsForResourceWithIdentifier: (ResID) resourceIdentifier;

- (short) countForResourceType: (ResType) resourceType;
- (NSData *) dataForResourceType: (ResType) resourceType atIndex: (short) index;

- (NSArray *)resourceTypes;
- (short)numberOfResourcesOfType:(NSString *)resourceType;
//- (NSArray *)resourcesOfType:(NSString *)resourceType;

@end
